<?php

namespace App\Http\Controllers;

use App\Models\Company;
use App\Models\InitialMessage;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class CompanyController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $companies = Company::all();



        return view('companies.index', ['companies' => $companies,]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {


        if (!auth()->user()->hasRole('admin')) {
            abort(Response::HTTP_UNAUTHORIZED);


         }




        $companies = [];
        return view('companies.create', ['companies' => $companies,'message' => InitialMessage::first()]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $r)
    {
        $validated = $this->validate($r, [
           'body' => ['required'],
        ]);


        InitialMessage::first()->update($validated);




        session()->put(['info' => 'Message updated']);

        return back();



    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Company  $company
     * @return \Illuminate\Http\Response
     */
    public function show(Company $company)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Company  $company
     * @return \Illuminate\Http\Response
     */
    public function edit(Company $company)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Company  $company
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Company $company)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Company  $company
     * @return \Illuminate\Http\Response
     */
    public function destroy(Company $company)
    {


        foreach($company->assets as $asset) {

            foreach($asset->projects as $project) {

                  $project->delete();

            }



        }


        $company->delete();



        session()->put('info', 'Company deleted');

        return back();
    }
}
