<?php

namespace App\Http\Controllers;

use App\Models\Company;
use App\Models\Project;
use App\Models\User;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use Illuminate\Http\Response;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {



        if (!auth()->user()->hasRole('admin')) {
            abort(Response::HTTP_UNAUTHORIZED);


        }



        $users = User::all()->filter(function($item) {
           if($item->id != auth()->user()->id) {


               return $item;
           }


        });



        $companies = [];



        return view('users.index', ['users' => $users, 'companies' => $companies]);


    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {


        if (!auth()->user()->hasRole('admin')) {
            abort(Response::HTTP_UNAUTHORIZED);


        }


        $companies = [];

        $roles = [];

        return view('users.create', ['roles' => $roles, 'companies' => $companies]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $r)
    {






//         $role = Role::find($r->role_id);

          $validated = $this->validate($r, [
             'name' => ['required',],
             'email' => ['required','email', 'unique:users'],
             'password' => ['required', 'min:2'],
              'role_id' => ['required'],


          ]);

        $validated['verified'] = $validated['role_id'];
          unset($validated['role_id']);
          $validated['password'] = bcrypt($validated['password']);
//          $validated['company_id'] = (int) $r->company_id;




//         if(!$role) {
//
//             return back();
//         }
//



           User::create($validated);

           session()->put(['message' => 'user created']);

           return back();


    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(User $user)
    {


        if (!auth()->user()->hasRole('admin')) {
            abort(Response::HTTP_UNAUTHORIZED);


        }




        $companies = [];

        $roles = [];

        return view('users.edit', ['roles' => $roles, 'companies' => $companies, 'user' => $user]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $r, $id)
    {
        $user = User::findOrFail($id);




//        $role = Role::findOrFail($r->role_id);


//        dd($r->company_id);






        $user->update([
           'name' => $r->name ? $r->name : $user->name,
           'email' => $r->email ? $r->email : $user->email,
//             'company_id' => $r->company_id,

                 'verified' => $r->role_id,


        ]);



//
//        if($r->role_id != 3) {
//
//            $user->update([
//                'company_id' => null,
//            ]);
//
//
//        }
//






        if(!empty($r->password)) {

            $user->update([
                'password' => bcrypt($r->password),
            ]);




        }





//        $user->roles()->detach();


//        $user->assignRole($role->name);






        session()->put('info', 'credentials updated');



        return redirect()->route('users.index');
























    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(User $user)
    {



        if($user->id === auth()->id()) {
            $user->delete();
            auth()->logout();
            return redirect('/');

        }


        $user->delete();

        session()->put(['info' => 'User deleted']);
        return back();
    }
}
