<?php

namespace App\Models;

use App\Scopes\ApplicationScope;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Project extends Model
{
    use HasFactory;
    protected $guarded = [];


    public function mini()
    {
        return $this->hasMany(MiniProject::class);
    }

    public function inspections()
    {
        return $this->hasMany(Inspection::class, 'project_id', 'id');
    }

    public function documents()
    {
        return $this->hasMany(Document::class);
    }
    public function generalDocuments()
    {
        return $this->hasMany(GeneralDocument::class);
    }


    public function repairs()
    {
        return $this->hasMany(RepairItem::class);
    }





    public function asset()
    {
        return $this->belongsTo(Asset::class, 'ass_id', 'id');
    }




    protected static function booted()
    {
        static::addGlobalScope(new ApplicationScope);
    }









}
