<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProjectsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('projects', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->unsignedBigInteger('ass_id')->nullable();
            $table->tinyInteger('is_active')->default(1);




            $table->string('overview_image')->default('project_images/default.jpg');

            $table->string('coordinate')->nullable();
            $table->string('name')->nullable();
            $table->string('asset_id')->nullable();
            $table->string('inspect_freq')->nullable();
            $table->date('next_inspect')->nullable();
            $table->string('general_document')->nullable();


            $table->longText('data')->nullable();



//
//            $table->string('name');
//            $table->string('street_name');
//            $table->string('structure_name');
//            $table->string('crossing_status');
//            $table->string('inspection_freq');
//            $table->date('next_inspection');
//            $table->enum('repairs_identified', ['high', 'low', 'medium']);
//
//
//
//
//           $table->string('park');
//           $table->string('road');
//           $table->decimal('user_km');
//
//
//
//            $table->string('feature_crossed');
//            $table->string('utm');
//            $table->string('wgs84');
//            $table->string('structure_type');
//            $table->string('is_surplus');
//
//
//            $table->string('year_built');
//            $table->decimal('length');
//            $table->decimal('deck_width');
//
//            $table->string('deck_type');
//
//






            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('projects');
    }
}
