@extends('master-app')



@section('contents')



    <div class="col-12 mt-0">



        <nav class="navbar  navbar-expand-sm navbar-light bg-info p-0" style="margin-top: -15px">
            <a class="navbar-brand ml-3" href="{{route('show.single.table', $project->asset->id)}}">
                <button class="btn btn-sm btn-success">
                    <i class="fa-solid fa-list-ul"></i>
                    Assets
                </button>

            </a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNavDropdown" aria-controls="navbarNavDropdown" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNavDropdown">
                <ul class="navbar-nav ml-auto">
                    <li class="nav-item active">
                        <span class="mr-2">
                        {{$project->name}}
                        </span>


                        <span class="sr-only">(current)</span>
                    </li>






                </ul>
            </div>
        </nav>







    </div>






















    <div class="col-12">
        <div class="card">
            <div class="card-header p-2">
                <ul class="nav nav-pills">
                    <li class="nav-item"><a class="nav-link active" href="#overviewy" data-toggle="tab">Overview</a></li>
                    <li class="nav-item"><a class="nav-link" id="inspections-btn" href="#inspections" data-toggle="tab">Inspections</a></li>

                    <li class="nav-item">
                        <a class="nav-link btn btn-sm btn-danger" style="color: #fff" href="#priority" id="priority-btn"  data-toggle="tab">
                            <i class="fa fa-exclamation-triangle" aria-hidden="true"></i>

                            High priority repairs</a>
                    </li>
                    <li class="nav-item"><a class="nav-link" href="#documents" id="documents-btn"  data-toggle="tab">Documents</a></li>
                    <li class="nav-item"><a class="nav-link" href="#photos" data-toggle="tab">Photos</a></li>
                </ul>
            </div><!-- /.card-header -->
            <div class="card-body">
                <div class="tab-content">
                    <div class="active tab-pane" id="overviewy">

                        <div class="container">
                            <div class="row">
                                <div class="col-3">
                                    <div class='lol'>
                                        <img src="/{{$project->overview_image}}" alt="" id="overview-image" style="height: 40vh" class="show">

                                        @if(canEditProject())

                                        <input type="file" id="overview-input" accept='image/*' onchange="showImage()">


                                            @endif
                                    </div>






                                </div>


                                {{--<div class="col-md-1"></div>--}}
                                <div class="col-9" id="the-big-box">





                                    {{--<div class="card">--}}
                                    {{--<!-- This script got from frontendfreecode.com -->--}}
                                    {{--<table class="table table-striped table-bordered">--}}
                                    {{--<thead class="thead-inverse">--}}
                                    {{--<tr>--}}
                                    {{--<td>Student Name<i class="fa fa-search pull-right" aria-hidden="true"></i></td>--}}
                                    {{--<td>School Number<span class="pull-right"><i class="fa fa-long-arrow-down" aria-hidden="true"></i><i class="fa fa-long-arrow-up" aria-hidden="true"></i><i class="fa fa-search pull-right" aria-hidden="true"></i></span></td>--}}


                                    {{--<th>--}}
                                    {{--General information--}}
                                    {{--</th>--}}



                                    {{--<th>--}}

                                    {{--<span style="visibility: hidden">--}}
                                    {{--General information--}}
                                    {{--</span>--}}


                                    {{--<i onclick="generalInformation({{$project->id}})" class="fa fa-edit" style="cursor: pointer; float: right;"></i>--}}


                                    {{--</th>--}}





                                    {{--</tr>--}}



                                    {{--</thead>--}}
                                    {{--<tbody id="tbody-{{$project->id}}">--}}
                                    {{--<tr>--}}
                                    {{--<td>--}}


                                    {{--<a onclick="return confirmDGDelete(this, 'Are you sure you want to delete this form instance?', '#F4F2F2', '#FFFFFF', '#fefebb');"--}}
                                    {{--title="Delete this form instance" class="btn btn-danger" href="javascript:__doPostBack('ctl08$ctl06$stMain$ctl28$dgForms$ctl05$ctl04','')"><i class="fa fa-trash"></i></a>--}}



                                    {{--</td>--}}

                                    {{--<td>Name</td>--}}
                                    {{--<td class="editable">{{$project->name}}</td>--}}
                                    {{--</tr>--}}


                                    {{--<tr>--}}
                                    {{--<td>Asset id</td>--}}
                                    {{--<td class="editable">{{$project->asset_id}}</td>--}}
                                    {{--</tr>--}}


                                    {{--<tr>--}}
                                    {{--<td>Coordinate</td>--}}
                                    {{--<td class="editable">{{$project->coordinate}}</td>--}}
                                    {{--</tr>--}}

                                    {{--<tr>--}}
                                    {{--<td>Inspection freq</td>--}}
                                    {{--<td class="editable">{{$project->inspect_freq}}</td>--}}
                                    {{--</tr>--}}
                                    {{--<tr>--}}
                                    {{--<td>Next inspection</td>--}}
                                    {{--<td><input readonly id="date-field-{{$project->id}}" type="date" value="{{$project->next_inspect}}"> </td>--}}


                                    {{----}}
                                    {{--</tr>--}}















                                    {{--</tbody>--}}
                                    {{--</table>--}}

                                    {{--<div id="card-footer-{{$project->id}}" class="card-footer" style="display: none">--}}
                                    {{--<button class="btn btn-sm btn-secondary" onclick="addRow({{$project->id}})">--}}
                                    {{--<i class="fas fa-plus"></i>--}}

                                    {{--Add--}}
                                    {{--</button>--}}

                                    {{--<button class="btn btn-sm btn-danger" onclick="removeRow({{$project->id}})">--}}
                                    {{--<i class="fas fa-minus"></i>--}}

                                    {{--remove--}}
                                    {{--</button>--}}




                                    {{--<button onclick="save({{$project->id}})" style="float: right"  class="btn btn-sm btn-primary">--}}
                                    {{--<i class="fas fa-save"></i>--}}
                                    {{--Save</button>--}}

                                    {{--<span style="clear: both"></span>--}}


                                    {{--</div>--}}

                                    {{--</div>--}}


                                    <div class="card" >
                                        <div class="card-header">
                                            <h3 class="card-title">General information </h3>

                                            <div class="card-tools">
                                                {{--<button type="button"  class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i>--}}
                                                {{--</button>--}}

                                                @if(canEditProject())
                                                <i onclick="generalInformation({{$project->id}})" class="fa fa-edit" style="cursor: pointer; color: green;"></i>

                                                @endif


                                                {{--<button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i>--}}
                                                {{--</button>--}}
                                            </div>
                                        </div>
                                        <!-- /.card-header -->

                                        <!-- /.card-body -->
                                        <div class="card-body">
                                            <form id="general-information-{{$project->id}}">
                                                <table class="table table-bordered">

                                                    <tbody id="tbody-{{$project->id}}">

                                                    <tr>
                                                        <td>
                                                            <input  class="form-control" type="text" value="name" readonly="">


                                                        </td>

                                                        <td>
                                                            <input class="form-control" type="text"  id="name-{{$project->id}}" value="{{$project->name}}" readonly="">


                                                        </td>

                                                    </tr>



                                                    <tr>
                                                        <td>
                                                            <input class="form-control" type="text" value="Asset id" readonly="">


                                                        </td>

                                                        <td>
                                                            <input class="form-control" type="text" id="asset_id-{{$project->id}}" value="{{$project->asset_id}}" readonly="">


                                                        </td>

                                                    </tr>




                                                    <tr>
                                                        <td>
                                                            <input type="text" class="form-control" value="Coordinate" readonly="">


                                                        </td>

                                                        <td>
                                                            <input type="text" id="coordinate-{{$project->id}}" class="form-control" value="{{$project->coordinate}}" readonly="">


                                                        </td>

                                                    </tr>






                                                    <tr>
                                                        <td>
                                                            <input type="text" class="form-control" value="Inspection freq" readonly="">


                                                        </td>

                                                        <td>
                                                            <input type="text" class="form-control" id="inspect_freq-{{$project->id}}" value="{{$project->inspect_freq}}" readonly="">


                                                        </td>

                                                    </tr>



                                                    <tr>
                                                        <td>
                                                            <input type="text" class="form-control" value="Next nspection" readonly="">


                                                        </td>

                                                        <td>
                                                            <input type="date" class="form-control" id="next_inspect-{{$project->id}}" value="{{$project->next_inspect}}" readonly="">


                                                        </td>

                                                    </tr>




























                                                    @if($project->data)

                                                        @foreach($project->data as $key => $val)
                                                            <tr id="x-{{$project->id.'-'.$loop->index}}">
                                                                <td>



                                                                    <div class="input-group stylish-input-group">





                                                                        {{--<i class="fas fa-trash delete-icon-{{$project->id}}"--}}

                                                                           {{--onclick="deleteXEL({{$project->id}}, {{$loop->index}})"--}}
                                                                           {{--style="color: darkred; cursor: pointer; display: none;"></i>--}}




                                                                        <input type="text" class="form-control c-{{$project->id}} added-cv-{{$project->id}}" value="{{$key}}" readonly="">

                                                                    </div>

                                                                </td>

                                                                <td>
                                                                    <input type="text"  class="form-control v-{{$project->id}} added-cv-{{$project->id}}" value="{{$val}}" readonly="">


                                                                </td>

                                                            </tr>




                                                        @endforeach


                                                    @endif











                                                    </tbody>
                                                </table>



                                            </form>




                                        </div>



                                        <div class="card-footer bg-white p-0" style="display: none" id="footer-{{$project->id}}">


                                            <div class="container">

                                                <div class="row">
                                                    @if($isFirst)

                                                        <div class="col-5">
                                                            <button onclick="addMethod({{$project->id}})" id="add-{{$project->id}}" class="btn btn-sm btn-secondary">
                                                                <i class="fas fa-plus"></i>
                                                                Add</button>


                                                            <button  onclick="removeMethod({{$project->id}})" id="remove-{{$project->id}}" style="display: none;" class="btn btn-sm btn-danger">
                                                                <i class="fas fa-minus"></i>
                                                                Remove</button>

                                                        </div>
                                                    @else


                                                        <div class="col-5" style="visibility: hidden">
                                                            <button onclick="addMethod({{$project->id}})" id="add-{{$project->id}}" class="btn btn-sm btn-secondary">
                                                                <i class="fas fa-plus"></i>
                                                                Add</button>


                                                            <button  onclick="removeMethod({{$project->id}})" id="remove-{{$project->id}}" style="display: none;" class="btn btn-sm btn-danger">
                                                                <i class="fas fa-minus"></i>
                                                                Remove</button>

                                                        </div>




                                                    @endif



                                                    <div class="col-7">
                                                        <button onclick="save({{$project->id}})" style="float: right"  class="btn btn-primary">
                                                            <i class="fas fa-save"></i>
                                                            Save</button>

                                                    </div>
                                                </div>






                                            </div>







                                        </div>
                                        <!-- /.footer -->






                                    </div>


                                    @foreach($project->mini as $mini)

                                        <div class="card" id="card-{{$mini->uid}}" >
                                            <input type="hidden" id="uid-{{$mini->uid}}" value="{{$mini->uid}}">
                                            <div class="card-header">
                                                <h3 class="card-title"><input type="text"  value="{{$mini->title}}"  readonly class="form-control title-{{$mini->uid}}"></h3>

                                                <div class="card-tools">
                                                     @if(!auth()->user()->hasRole('client'))

                                                    <i onclick="editInformation('{{$mini->uid}}')" class="fa fa-edit" style="cursor: pointer; color: green;"></i>
                                                    <i onclick="trashInformation('{{$mini->uid}}')" class="fa fa-trash" style="cursor: pointer; color: darkred;"></i>
                                                      @endif








                                                </div>
                                            </div>
                                            <!-- /.card-header -->

                                            <!-- /.card-body -->
                                            <div class="card-body">
                                                <form id="form-{{$mini->uid}}">
                                                    <table class="table table-bordered">

                                                        <tbody id="tbody-{{$mini->uid}}">






                                                        @foreach($mini->data as $key => $value)

                                                            <tr id="x-{{$mini->uid}}-{{$loop->index}}">
                                                                <td>



                                                                    <div class="input-group stylish-input-group">


                                                                        @if($loop->index > 0)


                                                                        <i class="fas fa-trash delete-icon-{{$mini->uid}}"

                                                                           onclick="deleteXEL('{{$mini->uid}}', '{{$loop->index}}')"
                                                                           style="color: darkred; cursor: pointer; display: none;"></i>

                                                                             @endif


                                                                        <input readonly value="{{$key}}" type="text" class="form-control c-{{$mini->uid}} added-cv-{{$mini->uid}}" >

                                                                    </div>

                                                                </td>

                                                                <td>
                                                                    <input type="text"  readonly value="{{$value}}" class="form-control v-{{$mini->uid}} added-cv-{{$mini->uid}}">


                                                                </td>

                                                            </tr>




                                                        @endforeach














                                                        </tbody>
                                                    </table>



                                                </form>




                                            </div>



                                            <div class="card-footer bg-white p-0" id="footer-{{$mini->uid}}" style="display: none">


                                                <div class="container">

                                                    <div class="row">
                                                        <div class="col-5">
                                                            <button onclick="addBtn('{{$mini->uid}}')" id="add-{{$mini->uid}}" class="btn btn-sm btn-secondary">
                                                                <i class="fas fa-plus"></i>
                                                                Add</button>


                                                            <button  onclick="removeMethod('{{$mini->uid}}')" id="remove-{{$mini->uid}}" style="display: none;" class="btn btn-sm btn-danger">
                                                                <i class="fas fa-minus"></i>
                                                                Remove</button>

                                                        </div>


                                                        <div class="col-7">
                                                            <button onclick="saveBox('{{$mini->uid}}', '{{$project->id}}')" style="float: right"  id="save-btn-{{$mini->uid}}" class="btn btn-primary">
                                                                <i class="fas fa-save"></i>
                                                                Save</button>

                                                        </div>
                                                    </div>






                                                </div>







                                            </div>







                                        </div>



                                    @endforeach






















                                </div>













                            </div>








                            <div class="row justify-content-end">
                                <div class="col-12">


                                    @if(canEditProject())
                                    <i class="fas fa-plus"  onclick="addBox(Math.floor(Math.random() * 1000), {{$project->id}})" style="font-size: 20px; cursor: pointer; float: right;"></i>
                                    <span style="clear: both"></span>
                                        @endif

                                </div>
                            </div>


                        </div>










                        <!-- /.post -->
                    </div>
                    <!-- /.tab-pane -->
                    <div class="tab-pane" id="inspections">
                        <!-- The timeline -->
                        <div class="timeline timeline-inverse">
                            <!-- timeline time label -->
                            <div class="time-label">
                        <span class="bg-danger">
                          {{$project->next_inspect}}
                        </span>
                                Next inspection due

                                @if(canEditProject())


                                <button style="float: right;" class="btn btn-primary" data-toggle="modal" data-target="#exampleModal">
                                     <i class="fas fa-plus"   ></i>
                                    Add
                                </button>
                                <span style="clear: both"></span>

                                @endif




                                {{--  modal markup--}}


                                     @include('partials.inspection_modal')

                                {{--END MODAL MARKUP--}}





                            </div>






                            <!-- /.timeline-label -->
                            <!-- timeline item -->

                            @foreach($project->inspections()->orderBy('id', 'desc')->get() as $inspection)


                            <div>
                                {{--<i class="fas fa-envelope bg-primary"></i>--}}

                                <i class="fas fa-circle bg-primary"></i>



                                <div class="timeline-item">
                                    {{--<span class="time"><i class="far fa-clock"></i> 12:05</span>--}}

                                    <h3 class="timeline-header"><a href="#">{{$inspection->date}} - </a> inspection by <strong>{{$inspection->inspected_by}}</strong></h3>

                                    <div class="timeline-body">
                                       {{$inspection->description}}






                                    </div>




                                    <div>
                                        {{--<i class="fas fa-camera bg-purple"></i>--}}

                                        <div class="timeline-item">
                                            {{--<span class="time"><i class="far fa-clock"></i> 2 days ago</span>--}}

                                            {{--<h3 class="timeline-header"><a href="#">Mina Lee</a> uploaded new photos</h3>--}}

                                            <div class="timeline-body">

                                                @foreach($inspection->photos as $photo)



                                                <img id="myImg-{{$photo->id}}"  class="myImg" src="/{{$photo->photo}}" alt="..." style="width: 150px; height: 100px;">


                                                    <!-- The Modal -->
                                                    <div id="myModal-{{$photo->id}}" class="modal-image myModal">
                                                        <span class="close">&times;</span>
                                                        <img class="modal-content img01" id="img01" >
                                                        <div id="caption"  class="caption"></div>
                                                    </div>




                                                @endforeach
                                            </div>
                                        </div>
                                    </div>






                                    {{--<div class="timeline-footer">--}}
                                        {{--<a href="#" class="btn btn-primary btn-sm">Read more</a>--}}
                                        {{--<a href="#" class="btn btn-danger btn-sm">Delete</a>--}}
                                    {{--</div>--}}
                                    {{----}}




                                </div>
                            </div>


                            @endforeach


                            <!-- END timeline item -->
                            <!-- timeline item -->
                            {{--<div>--}}
                                {{--<i class="fas fa-user bg-info"></i>--}}

                                {{--<div class="timeline-item">--}}
                                    {{--<span class="time"><i class="far fa-clock"></i> 5 mins ago</span>--}}

                                    {{--<h3 class="timeline-header border-0"><a href="#">Sarah Young</a> accepted your friend request--}}
                                    {{--</h3>--}}
                                {{--</div>--}}
                            {{--</div>--}}
                            <!-- END timeline item -->
                            <!-- timeline item -->
                            {{--<div>--}}
                                {{--<i class="fas fa-comments bg-warning"></i>--}}

                                {{--<div class="timeline-item">--}}
                                    {{--<span class="time"><i class="far fa-clock"></i> 27 mins ago</span>--}}

                                    {{--<h3 class="timeline-header"><a href="#">Jay White</a> commented on your post</h3>--}}

                                    {{--<div class="timeline-body">--}}
                                        {{--Take me to your leader!--}}
                                        {{--Switzerland is small and neutral!--}}
                                        {{--We are more like Germany, ambitious and misunderstood!--}}
                                    {{--</div>--}}
                                    {{--<div class="timeline-footer">--}}
                                        {{--<a href="#" class="btn btn-warning btn-flat btn-sm">View comment</a>--}}
                                    {{--</div>--}}
                                {{--</div>--}}
                            {{--</div>--}}
                            <!-- END timeline item -->
                            <!-- timeline time label -->



                            {{--<div class="time-label">--}}
                        {{--<span class="bg-success">--}}
                          {{--3 Jan. 2014--}}
                        {{--</span>--}}
                            {{--</div>--}}





                            <!-- END timeline item -->
                            <div>
                                {{--<i class="far fa-clock bg-gray"></i>--}}
                            </div>
                        </div>



                    </div>
                    <!-- /.tab-pane -->

                    <div class="tab-pane" id="priority">
                            @include('partials.repair')




                    </div>
                    <div class="tab-pane" id="documents">





                        @include('partials.documents')



                    </div>
                    <div class="tab-pane" id="photos">


                        @include('partials.photos')



                    </div>
                    <!-- /.tab-pane -->
                </div>
                <!-- /.tab-content -->
            </div><!-- /.card-body -->
        </div>
        <!-- /.nav-tabs-custom -->
    </div>


@endsection




@section('header')

    {{--<nav class="navbar navbar-expand-lg navbar-light bg-dark">--}}
        {{--<a class="navbar-brand ml-3" href="#">{{$project->company->name}}</a>--}}
        {{--<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNavDropdown" aria-controls="navbarNavDropdown" aria-expanded="false" aria-label="Toggle navigation">--}}
            {{--<span class="navbar-toggler-icon"></span>--}}
        {{--</button>--}}
        {{--<div class="collapse navbar-collapse" id="navbarNavDropdown">--}}
            {{--<ul class="navbar-nav ml-auto">--}}
                {{--<li class="nav-item active">--}}
                    {{--<a class="nav-link" href="{{route('company.projects', $project->company->id)}}" style="color: #fff;">Projects <span class="sr-only">(current)</span></a>--}}
                {{--</li>--}}


                {{--<li class="nav-item">--}}
                    {{--<a class="nav-link" href="#" style="color: #fff;">{{$project->name}}</a>--}}
                {{--</li>--}}
                {{--<li class="nav-item">--}}
                    {{--<a class="nav-link" href="#" style="color: #fff;">Create</a>--}}
                {{--</li>--}}

            {{--</ul>--}}
        {{--</div>--}}
    {{--</nav>--}}

@endsection



@section('scripts')

    <script>
        const isFirst = {!! json_encode($isFirst) !!};
    </script>



    <script src="/helper.js"></script>
    <script src="/addBox.js"></script>


    <script>


        const inspectionsBtn = document.getElementById('inspections-btn');
        const documentsBtn = document.getElementById('documents-btn');
        const priorityBtn = document.getElementById('priority-btn');

        @if(session('inspections'))
        inspectionsBtn.click();
        let xs = "{{session()->pull('inspections')}}";

                @endif



                @if(session('documents'))
                documentsBtn.click();
        let xs = "{{session()->pull('documents')}}";

                @endif






                @if(session('priority'))
                priorityBtn.click();
        let xs = "{{session()->pull('priority')}}";

                @endif





        const project = @json($project);





        const imageUploader = document.getElementById('overview-input');
        const imagePreview = document.getElementById("overview-image");


        function showImage() {
            let reader = new FileReader();


            reader.readAsDataURL(imageUploader.files[0]);
            reader.onload = function(e) {
                imagePreview.classList.add("show");

                imagePreview.src = e.target.result;



                axios({
                    method: 'post',
                    url: '/projects/overview-image',
                    data: {
                        image: e.target.result,
                        project_id: project.id,
                    }


                }).
                then(res => {








                });










            };











        }



        // function addRow(id) {
        //     const tbody = document.getElementById('tbody-'+id);
        //       let str = `
        //
        //           <td contenteditable="true"></td>
        //           <td contenteditable="true"></td>
        //
        //       `;
        //
        //
        //       let el = document.createElement('tr')
        //     el.classList.add('cv-'+id);
        //       el.innerHTML = str;
        //
        //       tbody.appendChild(el);
        //
        //
        //
        //
        //
        //
        // }
        //
        //
        //
        // function removeRow(id) {
        //
        //      const tr = document.getElementsByClassName('cv-'+id)[document.getElementsByClassName('cv-'+id).length-1];
        //
        //
        //        if(tr) {
        //
        //
        //            tr.remove();
        //
        //        }
        //
        //
        // }
        //
        //
        //
        // function generalInformation(id) {
        //       const editables = Array.from(document.getElementsByClassName('editable'));
        //       const dateField = document.getElementById('date-field-'+id);
        //
        //
        //       dateField.removeAttribute('readonly');
        //
        //
        //
        //       editables.forEach((item, index) => {
        //
        //          item.setAttribute('contenteditable', true);
        //
        //       });
        //
        //
        //
        //       $("#card-footer-"+id).slideDown();
        //
        //
        //
        //
        //
        // }
        //
        //
        //
        // function save(id) {
        //
        //     alert(id);
        //
        //
        // }
        //





               //  IMAGE MODAL


               var modal = Array.from(document.getElementsByClassName("myModal"));

               // Get the image and insert it inside the modal - use its "alt" text as a caption
               var img = Array.from(document.getElementsByClassName("myImg"));





               var modalImg = Array.from(document.getElementsByClassName("img01"));
               var captionText = Array.from(document.getElementsByClassName("caption"));



               modal.forEach((item, index) => {
                   img[index].onclick = function(){
                       item.style.display = "block";
                       modalImg[index].src = this.src;
                       captionText[index].innerHTML = this.alt;
                   }

                   // Get the <span> element that closes the modal
                   var span = document.getElementsByClassName("close")[index];

                   // When the user clicks on <span> (x), close the modal
                   span.onclick = function() {
                       modal[index].style.display = "none";
                   }



               });

    // END IMAGE MODAL









    //     MODAL JS

               $('#exampleModal').on('show.bs.modal', function (event) {
                   var button = $(event.relatedTarget) // Button that triggered the modal
                   // Extract info from data-* attributes
                   // If necessary, you could initiate an AJAX request here (and then do the updating in a callback).
                   // Update the modal's content. We'll use jQuery here, but you could use a data binding library or other methods instead.
                   var modal = $(this)
                   modal.find('.modal-title');
                   modal.find('.modal-body input');
               });


    //    END MODAL JS




    //     IMAGE PREVIEW INSIDE MODEL




               $(document).ready(function() {
                   if (window.File && window.FileList && window.FileReader) {
                       $("#files").on("change", function(e) {
                           var files = e.target.files,
                               filesLength = files.length;
                           for (var i = 0; i < filesLength; i++) {
                               var f = files[i]
                               var fileReader = new FileReader();
                               fileReader.onload = (function(e) {
                                   var file = e.target;
                                   $("<span class=\"pip\">" +
                                       "<img class=\"imageThumb\" src=\"" + e.target.result + "\" title=\"" + file.name + "\"/>" +
                                       "<br/><span class=\"remove\">Remove image</span>" +
                                       "</span>").insertAfter("#files");
                                   $(".remove").click(function(){
                                       $(this).parent(".pip").remove();
                                   });

                                   // Old code here
                                   /*$("<img></img>", {
                                     class: "imageThumb",
                                     src: e.target.result,
                                     title: file.name + " | Click to remove"
                                   }).insertAfter("#files").click(function(){$(this).remove();});*/

                               });
                               fileReader.readAsDataURL(f);
                           }
                           console.log(files);
                       });
                   } else {
                       alert("Your browser doesn't support to File API")
                   }
               });





               //    END IMAGE PRVIEW INSIDE MODAL


    </script>

@endsection






@section('styles')

    <style>
        .lol {
            display: flex;
            justify-content: center;
            flex-direction: column;
            flex-wrap: wrap;
            text-align: center;
            align-content: center;
        }

        #overview-image {
            width: 100%;
            max-width: 300px;
            border: 1px solid #ccc;
            box-shadow: 0px 3px 8px #ccc;
            border-radius: 5px;
            padding: 4px;
            display: none;
        }
        #overview-image.show {
            display: block;
        }

        #overview-input {
            width: 100%;
        }




        /*IMAGE MODEL*/



        .myImg {
            border-radius: 5px;
            cursor: pointer;
            transition: 0.3s;
        }

        .myImg:hover {opacity: 0.7;}

        /* The Modal (background) */
        .modal-image {
            display: none; /* Hidden by default */
            position: fixed; /* Stay in place */
            z-index: 10000; /* Sit on top */
            padding-top: 100px; /* Location of the box */
            left: 0;
            top: 0;
            width: 100%; /* Full width */
            height: 100%; /* Full height */
            overflow: auto; /* Enable scroll if needed */
            background-color: rgb(0,0,0); /* Fallback color */
            background-color: rgba(0,0,0,0.9); /* Black w/ opacity */
        }

        /* Modal Content (image) */
        .modal-content {
            margin: auto;
            display: block;
            width: 80%;
            max-width: 700px;
        }

        /* Caption of Modal Image */
        .caption {
            margin: auto;
            display: block;
            width: 80%;
            max-width: 700px;
            text-align: center;
            color: #ccc;
            padding: 10px 0;
            height: 150px;
        }

        /* Add Animation */
        .modal-content, .caption {
            -webkit-animation-name: zoom;
            -webkit-animation-duration: 0.6s;
            animation-name: zoom;
            animation-duration: 0.6s;
        }

        @-webkit-keyframes zoom {
            from {-webkit-transform:scale(0)}
            to {-webkit-transform:scale(1)}
        }

        @keyframes zoom {
            from {transform:scale(0)}
            to {transform:scale(1)}
        }

        /* The Close Button */
        .close {
            position: absolute;
            top: 15px;
            right: 35px;
            color: #f1f1f1;
            font-size: 40px;
            font-weight: bold;
            transition: 0.3s;
        }

        .close:hover,
        .close:focus {
            color: #bbb;
            text-decoration: none;
            cursor: pointer;
        }

        /* 100% Image Width on Smaller Screens */
        @media only screen and (max-width: 700px){
            .modal-content {
                width: 100%;
            }
        }






        /*END IMAGE MODEL*/





        /* image inside modal*/


        input[type="file"] {
            display: block;
        }
        .imageThumb {
            max-height: 75px;
            border: 2px solid;
            padding: 1px;
            cursor: pointer;
        }
        .pip {
            display: inline-block;
            margin: 10px 10px 0 0;
        }
        .remove {
            display: block;
            background: #444;
            border: 1px solid black;
            color: white;
            text-align: center;
            cursor: pointer;
        }
        .remove:hover {
            background: white;
            color: black;
        }




        /* end image inside modal*/











    </style>
@endsection




