@extends('app')



@section('content')




    <div class="wrapper">

    @include('layouts.nav')

    <!-- Main Sidebar Container -->
    @include('layouts.sidebar')
    <!-- Content Wrapper. Contains page content -->




        <div class="content-wrapper">
            <!-- Content Header (Page header) -->


        {{--@include('layouts.contentHeader')--}}
        <!-- /.content-header -->

            <!-- Main content -->


            <div class="container-fluid">
                <div class="row">
                    <div id="map" class="col-12" >

                    </div>


                    @foreach($projects as $project)




                    <div id="multi-column-{{$project->id}}" class="col-5 multi-columns" style="display: none; overflow: scroll; height: 100vh;">

                        <div class="card">
                            <img style="width: 100%; height: 200px;" src="/{{$project->overview_image}}">

                            <div class="card-footer">
                                <a href="{{route('projects.show', $project->id)}}">{{$project->name}}</a>

                            </div>


                        </div>



                        <div class="card" >
                            <div class="card-header">
                                <h3 class="card-title">General information </h3>

                                <div class="card-tools">
                                    <button type="button"  class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i>
                                    </button>


                                    {{--<i onclick="generalInformation({{$project->id}})" class="fa fa-edit" style="cursor: pointer;"></i>--}}




                                    {{--<button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i>--}}
                                    {{--</button>--}}
                                </div>
                            </div>
                            <!-- /.card-header -->

                            <!-- /.card-body -->
                            <div class="card-body">
                                <form id="general-information-{{$project->id}}">
                                    <table class="table table-bordered">

                                        <tbody id="tbody-{{$project->id}}">

                                        <tr>
                                            <td>
                                                <input  class="form-control" type="text" value="name" readonly="">


                                            </td>

                                            <td>
                                                <input class="form-control" type="text"  id="name-{{$project->id}}" value="{{$project->name}}" readonly="">


                                            </td>

                                        </tr>



                                        <tr>
                                            <td>
                                                <input class="form-control" type="text" value="Asset id" readonly="">


                                            </td>

                                            <td>
                                                <input class="form-control" type="text" id="asset_id-{{$project->id}}" value="{{$project->asset_id}}" readonly="">


                                            </td>

                                        </tr>




                                        <tr>
                                            <td>
                                                <input type="text" class="form-control" value="Coordinate" readonly="">


                                            </td>

                                            <td>
                                                <input type="text" id="coordinate-{{$project->id}}" class="form-control" value="{{$project->coordinate}}" readonly="">


                                            </td>

                                        </tr>






                                        <tr>
                                            <td>
                                                <input type="text" class="form-control" value="Inspection freq" readonly="">


                                            </td>

                                            <td>
                                                <input type="text" class="form-control" id="inspect_freq-{{$project->id}}" value="{{$project->inspect_freq}}" readonly="">


                                            </td>

                                        </tr>



                                        <tr>
                                            <td>
                                                <input type="text" class="form-control" value="Next nspection" readonly="">


                                            </td>

                                            <td>
                                                <input type="text" class="form-control" id="next_inspect-{{$project->id}}" value="{{$project->next_inspect}}" readonly="">


                                            </td>

                                        </tr>



                                       @if($project->data)

                                        @foreach($project->data as $key => $val)
                                            <tr id="x-{{$project->id.'-'.$loop->index}}">
                                                <td>



                                                    <div class="input-group stylish-input-group">





                                                        <i class="fas fa-trash delete-icon-{{$project->id}}"

                                                           onclick="deleteXEL({{$project->id}}, {{$loop->index}})"
                                                           style="color: darkred; cursor: pointer; display: none;"></i>




                                                    <input type="text" class="form-control c-{{$project->id}} added-cv-{{$project->id}}" value="{{$key}}" readonly="">

                                                    </div>

                                                </td>

                                                <td>
                                                    <input type="text"  class="form-control v-{{$project->id}} added-cv-{{$project->id}}" value="{{$val}}" readonly="">


                                                </td>

                                            </tr>




                                            @endforeach


                                           @endif











                                        </tbody>
                                    </table>



                                </form>




                            </div>



                            <div class="card-footer bg-white p-0" style="display: none" id="footer-{{$project->id}}">


                            <div class="container">

                                {{--<div class="row">--}}
                                    {{--<div class="col-5">--}}
                                        {{--<button onclick="addMethod({{$project->id}})" id="add-{{$project->id}}" class="btn btn-sm btn-secondary">--}}
                                            {{--<i class="fas fa-plus"></i>--}}
                                            {{--Add</button>--}}


                                        {{--<button  onclick="removeMethod({{$project->id}})" id="remove-{{$project->id}}" style="display: none;" class="btn btn-sm btn-danger">--}}
                                            {{--<i class="fas fa-minus"></i>--}}
                                            {{--Remove</button>--}}

                                    {{--</div>--}}


                                    {{--<div class="col-7">--}}
                                        {{--<button onclick="save({{$project->id}})" style="float: right"  class="btn btn-primary">--}}
                                            {{--<i class="fas fa-save"></i>--}}
                                            {{--Save</button>--}}

                                    {{--</div>--}}
                                {{--</div>--}}
                                {{----}}
                                {{----}}




                            </div>







                            </div>
                            <!-- /.footer -->






                        </div>




                        @foreach($project->mini as $mini)




                                    <div class="card" >
                                        <div class="card-header">
                                            <h3 class="card-title">{{$mini->title}} </h3>

                                            <div class="card-tools">
                                                <button type="button"  class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i>
                                                </button>


                                                {{--<i onclick="generalInformation({{$project->id}})" class="fa fa-edit" style="cursor: pointer;"></i>--}}




                                                {{--<button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i>--}}
                                                {{--</button>--}}
                                            </div>
                                        </div>
                                        <!-- /.card-header -->

                                        <!-- /.card-body -->
                                        <div class="card-body">
                                            <form id="general-information-{{$project->id}}">
                                                <table class="table table-bordered">

                                                    <tbody id="tbody-{{$project->id}}">
                                                    @if($mini->data)


                                                        @foreach($mini->data as $key => $val)



                                                            <tr>
                                                                <td>



                                                                        <input type="text" class="form-control c-{{$project->id}} added-cv-{{$project->id}}" value="{{$key}}" readonly="">



                                                                </td>

                                                                <td>
                                                                    <input type="text"  class="form-control v-{{$project->id}} added-cv-{{$project->id}}" value="{{$val}}" readonly="">


                                                                </td>

                                                            </tr>











                                                     @endforeach
                                                        @endif


                                                    </tbody>
                                                </table>



                                            </form>




                                        </div>



                                        <div class="card-footer bg-white p-0" style="display: none" id="footer-{{$project->id}}">


                                            <div class="container">

                                                {{--<div class="row">--}}
                                                {{--<div class="col-5">--}}
                                                {{--<button onclick="addMethod({{$project->id}})" id="add-{{$project->id}}" class="btn btn-sm btn-secondary">--}}
                                                {{--<i class="fas fa-plus"></i>--}}
                                                {{--Add</button>--}}


                                                {{--<button  onclick="removeMethod({{$project->id}})" id="remove-{{$project->id}}" style="display: none;" class="btn btn-sm btn-danger">--}}
                                                {{--<i class="fas fa-minus"></i>--}}
                                                {{--Remove</button>--}}

                                                {{--</div>--}}


                                                {{--<div class="col-7">--}}
                                                {{--<button onclick="save({{$project->id}})" style="float: right"  class="btn btn-primary">--}}
                                                {{--<i class="fas fa-save"></i>--}}
                                                {{--Save</button>--}}

                                                {{--</div>--}}
                                                {{--</div>--}}
                                                {{----}}
                                                {{----}}




                                            </div>







                                        </div>
                                        <!-- /.footer -->






                                    </div>














                            @endforeach



























                    </div>




                    @endforeach




                </div>
            </div>


        {{--@include('layouts.mainContent')--}}



        <!-- /.content -->
        </div>





        <!-- /.content-wrapper -->
    {{--@include('layouts.footer')--}}

    <!-- Control Sidebar -->
        <aside class="control-sidebar control-sidebar-dark">
            <!-- Control sidebar content goes here -->
        </aside>
        <!-- /.control-sidebar -->
    </div>




@endsection



@section('scripts')
      {{--LEAFLET MAP--}}
      <script src="/js/coords_helper.js"></script>

    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js" integrity="sha256-20nQCchB9co0qIjJZRGuk2/Z9VM+kNiyxNV1lvTlZBo=" crossorigin=""></script>

    <script>


            const projects = @json($projects);
            let token = true;
            let zoomLevel = 10;








        const map = L.map('map');
        const mapEL = document.getElementById('map');
        const multiColumns = Array.from(document.getElementsByClassName('multi-columns'));





        map.setView([51.0447,-114.0719], 4);



        var osm = L.tileLayer('https://tile.openstreetmap.org/{z}/{x}/{y}.png', {
            maxZoom: 19,
            attribution: ''
        }).addTo(map);



        projects.forEach((item, index) => {



            let letLongArr = item.coordinate.split(',');

                   let lati = Number(letLongArr[0]);
                   let longi = Number(letLongArr[1]);


                   if(!isValidCoords(lati, longi)) {

                        return;

                   }


                   // console.log(lati, longi);

            let element = `
                 <h3>${item.name}</h3>
                 <span style="cursor: pointer; text-decoration: underline;" onclick="func(${item.id},${lati},${longi})">more details</span>
            `;


            L.marker([lati, longi], {
                title: item.name,



            }).bindPopup(element).
            addTo(map);



        });








        function func(id, lati, longi) {

            // const information = document.getElementById('more-information');

            const el = document.getElementById('multi-column-'+id);


            // mapEL.classList.toggle('col-12');
            // mapEL.classList.toggle('col-8');
            //



            mapEL.classList.remove('col-12');
            mapEL.classList.add('col-7');













                  multiColumns.forEach((item) => {
                      item.style.display = "none";



                  });



                  el.style.display = 'block';







            // el.style.display = 'block';




            map.setView([lati,longi], zoomLevel);
            zoomLevel += 5;
            map.invalidateSize();


            if(token) {







                //
                // map.zoomIn();
                // map.zoomIn();
                // map.zoomIn();
                // map.zoomIn();
                // map.zoomIn();













            }








            token = false;






        }


        map.on('click', function(e) {






            mapEL.classList.add('col-12');
            mapEL.classList.remove('col-7');
            multiColumns.forEach((item) => {





                item.style.display = "none";



            });


            map.invalidateSize();


            // this.zoomIn();

            // zoomLevel = 10;

            token = true;





        });


        // address to lat long

        // const address = "145 Kelley Blvd, Millbrook AL 36054";
        //
        // $.get(location.protocol + '//nominatim.openstreetmap.org/search?format=json&q='+address, function(data){
        //     console.log(data);
        // });





        {{-- END LEAFLET MAP--}}




        // setTimeout(function(){ map.invalidateSize()}, 400)



            map.on('zoomend', function(e) {
                console.log(e.target._zoom)

                if(e.target._zoom < 8) {
                    zoomLevel = 10;
                    // token = true;


                }
                // drawGrid();
            });




    </script>


      <script src="/helper.js"></script>



@endsection




@section('styles')
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" integrity="sha256-p4NxAoJBhIIN+hmNHrzRCf9tD/miZyoHS5obTRR9BMY=" crossorigin="" />

    <style>
        #map{
            /*width: 50px;*/
            height: 100vh;
        }

        .d-block {
            display: block;

        }
    </style>
    @endsection








