<?php

use Illuminate\Support\Facades\Route;

use Salman\GeoCode\Services\GeoCode;



//Route::get('/', [\App\Http\Controllers\HomeController::class, 'home'])->middleware('auth')->name('home');
Route::get('/', [\App\Http\Controllers\HomeController::class, 'home'])->name('home');

//53.5461,-113.4937
//43.6532,-79.3832
//49.2827,-123.1207
//51.0447,-114.0719




//Route::get('/chat', function() {
//
//                 $info = file_get_contents("info.txt");
//
//         return view('test', ['companies' => \App\Models\Company::all(), 'chat' => \App\Models\Chat::all(), 'info' => $info]);
////    $arr = [
////        ['name' => 'Hasnain', 'age' => 23],
////        ['name' => 'Aisha', 'age' => 43],
////        ['name' => 'Fozia', 'age' => 13],
////        ['name' => 'Kiran', 'age' => 33],
////
////    ];
////    $arr = 3;
//
////   return view('test', ['users' => $arr]);
//
//});
//



//  AUTH ROUTES

Route::get('/login', [\App\Http\Controllers\AuthController::class, 'loginView'])->name('login');
Route::get('/logout', [\App\Http\Controllers\AuthController::class, 'logout'])->name('logout');
Route::post('/login', [\App\Http\Controllers\AuthController::class, 'login'])->name('login.post');


// END AUTH ROUTE




Route::resource('/users', \App\Http\Controllers\UserController::class);

Route::post('/project-store/{id}/update', [\App\Http\Controllers\ProjectController::class, 'updated']);



Route::resource('/companies', \App\Http\Controllers\CompanyController::class);

Route::resource('/projects', \App\Http\Controllers\ProjectController::class);

Route::get('c-projects/{id}', [\App\Http\Controllers\ProjectController::class, 'showed'])->name('c-projects.show');


Route::get('/projects-table/{id}', [\App\Http\Controllers\ProjectController::class, 'showSingle'])->name('show.single.table');
Route::get('/projects-map/{id}', [\App\Http\Controllers\ProjectController::class, 'showSingleMap'])->name('show.single.map');






Route::post('/mini-projects', [\App\Http\Controllers\MiniProjectController::class, 'store']);
Route::delete('/mini-projects/{id}', [\App\Http\Controllers\MiniProjectController::class, 'destroy']);




Route::post('/projects/overview-image', [\App\Http\Controllers\ProjectController::class, 'uploadImage']);
Route::post('/projects/document', [\App\Http\Controllers\ProjectController::class, 'uploadDocument']);
Route::post('/projects/document/all', [\App\Http\Controllers\ProjectController::class, 'uploadDocumentAll']);
Route::post('/inactive-projects/overview-image', [\App\Http\Controllers\InactiveImageUploadController::class, 'upload']);


Route::post('/inspection', [\App\Http\Controllers\InspectionController::class, 'store'])->name('inspection.store');


Route::post('/doc-uploads', [\App\Http\Controllers\DocumentController::class, 'store'])->name('document.store');



Route::post('/repair', [\App\Http\Controllers\RepairItemController::class, 'store'])->name('repair.store');




Route::get('/company-projects/{id}', [\App\Http\Controllers\CompanyProjectController::class, 'show'])
    ->name('company.projects');

Route::get('/company-projects/{id}/create', [\App\Http\Controllers\CompanyProjectController::class, 'create'])
    ->name('company.projects.create');

Route::get('new-project/{id}/create', [\App\Http\Controllers\AssetController::class, 'create'])->name('asset.create');
Route::post('/new-project', [\App\Http\Controllers\AssetController::class, 'store'])->name('asset.store');





Route::post('/chat', [\App\Http\Controllers\ChatController::class, 'store']);
Route::get('/get-chat', [\App\Http\Controllers\ChatController::class, 'index']);




Route::view('/test', 'test');


Route::post('/info', [\App\Http\Controllers\InfoController::class, 'set'])->name('set.info');



Route::view('/feedback', 'review');